/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFetchType;
import filenet.vw.api.VWLoggingOptionType;
import filenet.vw.api.VWPersistentCollection;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWQueueQuery;
import filenet.vw.api.VWQueueStats;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWTimeUnitType;
import filenet.vw.api.VWWorkBasket;
import filenet.vw.base.VWObjectNotFoundException;
import filenet.vw.base.VWString;
import filenet.vw.server.InternalVWWorkBasket;
import filenet.vw.server.VWCommandSession;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class VWQueue
extends VWPersistentCollection
implements Serializable {
    private static final long serialVersionUID = 119040L;
    public static final int QUERY_NO_OPTIONS = 0;
    public static final int QUERY_READ_LOCKED = 1;
    public static final int QUERY_READ_BOUND = 2;
    public static final int QUERY_READ_UNWRITABLE = 4;
    public static final int QUERY_LOCK_OBJECTS = 16;
    public static final int QUERY_MIN_VALUES_INCLUSIVE = 32;
    public static final int QUERY_MAX_VALUES_INCLUSIVE = 64;
    public static final int QUERY_GET_SYSTEM_FIELDS = 256;
    public static final int QUERY_GET_TRANSLATED_SYSTEM_FIELDS = 512;
    public static final int QUERY_GET_NO_SYSTEM_FIELDS = 1024;
    public static final int QUERY_GET_NO_TRANSLATED_SYSTEM_FIELDS = 2048;
    public static final int QUERY_SORT_DESCENDING_ENABLED = 16384;
    public static final int QUERY_RESOLVE_NAMES = 8192;
    public static final int QUEUE_TYPE_PROCESS = 1;
    public static final int QUEUE_TYPE_USER_CENTRIC = 2;
    public static final int QUEUE_TYPE_SYSTEM = 3;
    protected String FSortRule = "F_SortRule";
    protected String FFifo = "F_Fifo";
    protected String[] operationNames = null;
    protected int queueType = 0;
    protected int userId = 0;
    protected int bufferSize = 50;
    protected boolean isConnectorQueue = false;
    protected static final VWString VSTR_NOWB = new VWString("vw.api.VWRolefetchInvalidWB", "WorkBasket {0} does not exist.");

    public static String _get_FILE_DATE() {
        return "$Date: 2010-07-09 22:14:56 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/6 $";
    }

    protected VWQueue(String name, VWSession serviceSession, int theQueueType, int theServerId, boolean isConnectorQueue) throws VWException {
        super(name, serviceSession, theServerId);
        this.queueType = theQueueType;
        this.isConnectorQueue = isConnectorQueue;
    }

    public int getQueueType() throws VWException {
        return this.queueType;
    }

    public int getCount() throws VWException {
        boolean userBoundQueueQuery = false;
        if (this.userCentricServer > -1) {
            userBoundQueueQuery = true;
        }
        return this.cmdSession.getQueueDepth(this.viewId, userBoundQueueQuery);
    }

    public int fetchCount() throws VWException {
        boolean userBoundQueueQuery = false;
        if (this.userCentricServer > -1) {
            userBoundQueueQuery = true;
        }
        return this.cmdSession.getQueueDepth(this.viewId, userBoundQueueQuery);
    }

    protected String getDestination(String serviceName, int isolatedRegion) {
        return VWCommandSession.queueDestination(serviceName, isolatedRegion, this.name, this.userCentricServer);
    }

    public VWQueueQuery startQuery(String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String filter, Object[] substitutionVars) throws VWException {
        if (!(indexName == null || indexName.length() <= 0 || this.FWobNum.equals(indexName) || this.FSortRule.equals(indexName) || this.FFifo.equals(indexName))) {
            this.fetchIndexKeyFields(indexName);
        }
        return new VWQueueQuery(this, indexName, minValues, maxValues, queryFlags, filter, substitutionVars, 2);
    }

    public VWQueueQuery createQuery(String indexName, Object[] firstValues, Object[] lastValues, int queryFlags, String filter, Object[] substitutionVars, int fetchType) throws VWException {
        if (!(indexName == null || indexName.length() <= 0 || this.FWobNum.equals(indexName) || this.FSortRule.equals(indexName) || this.FFifo.equals(indexName))) {
            this.fetchIndexKeyFields(indexName);
        }
        if (!VWFetchType.isValid(fetchType) || fetchType == 4) {
            throw new VWException("vw.api.VWQueuefetchTypeInvalid", "Fetch type for VWQueue is not valid. {0}", new Integer(fetchType));
        }
        return new VWQueueQuery(this, this.authorStr(indexName), firstValues, lastValues, queryFlags, filter, substitutionVars, 2, this.bufferSize, fetchType);
    }

    public VWSession getServiceSession() {
        return this.serviceSession;
    }

    public VWQueueDefinition fetchQueueDefinition() throws VWException {
        VWQueueDefinition queueDef = this.cmdSession.getQueueDefinition(this.getAuthoredName());
        queueDef.setSession(this.getSession());
        return queueDef;
    }

    public String[] fetchQueueFields() throws VWException {
        String[] transFields = this.cmdSession.getExposedFields(this.getAuthoredName());
        return this.translateArr(transFields);
    }

    public String[] fetchIndexFields() throws VWException {
        String aIndex = null;
        Hashtable ihash = this.cmdSession.getIndexFields(this.getAuthoredName());
        Enumeration ikeys = ihash.keys();
        int count = ihash.size();
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            if (!ikeys.hasMoreElements()) continue;
            result[i] = aIndex = (String)ikeys.nextElement();
        }
        return this.translateArr(result);
    }

    public String[] fetchIndexKeyFields(String indexField) throws VWException {
        if (indexField == null) {
            throw new VWException("vw.api.VWQueuefetchIndexKeyFieldsBadName", "Index field parameter is null.");
        }
        Hashtable ihash = this.cmdSession.getIndexFields(this.getAuthoredName());
        String[] result = (String[])ihash.get(this.authorStr(indexField));
        if (result == null) {
            throw new VWException("vw.api.VWQueuefetchIndexKeyFieldsNoIndexFound", "Index name not found. Index names are case sensitive. Check spelling and case.");
        }
        return this.translateArr(result);
    }

    public VWQueueStats fetchStatistics(Date startTime, Date endTime, int timeUnits) throws VWException {
        if (!VWTimeUnitType.isValid(timeUnits)) {
            throw new VWException("vw.api.VWQueueInvalidTimeUnitType", "Invalid time unit type.");
        }
        VWQueueStats result = this.cmdSession.getQueueStatistics(this.viewId, startTime, endTime, timeUnits);
        result.setClassName(this.name);
        result.setSession(this.cmdSession);
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public void setBufferSize(int theNewSize) throws VWException {
        if (theNewSize < 1) {
            throw new VWException("vw.api.VWQueuefetchBufferSizeInvalid", "Buffer size specified to fetch is not valid.");
        }
        this.bufferSize = theNewSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int convertOperationNameToId(String theOperationName) throws VWException {
        if (theOperationName == null || theOperationName.length() < 1) {
            throw new VWException("vw.api.VWQueueConvertOToIOperationNameBad", "Parameter operation name is null.");
        }
        int id = -1;
        boolean fetchedOperations = false;
        do {
            if (this.operationNames == null) {
                this.operationNames = this.cmdSession.getQueueOperations(this.getAuthoredName());
                fetchedOperations = true;
            }
            if (this.operationNames != null) {
                for (int i = 0; i < this.operationNames.length; ++i) {
                    if (!theOperationName.equals(this.operationNames[i]) && !theOperationName.equals(this.translateStr(this.operationNames[i]))) continue;
                    id = i;
                }
            }
            if (id != -1) continue;
            this.operationNames = null;
        } while (id == -1 && !fetchedOperations);
        if (id < 0) {
            throw new VWException("vw.api.VWQueueConvertOToIOperationNameNotFound", "Operation name not found. {0}", theOperationName);
        }
        return id;
    }

    public String convertOperationIdToName(int theOperationId) throws VWException {
        String opname = null;
        boolean fetchedOperations = false;
        if (theOperationId < 0) {
            throw new VWException("vw.api.VWQueueConvertIToOOperationIdBad", "Operation Id is bad.  Must be greater than -1.");
        }
        do {
            if (this.operationNames == null) {
                this.operationNames = this.cmdSession.getQueueOperations(this.getAuthoredName());
                fetchedOperations = true;
            }
            if (this.operationNames != null && theOperationId < this.operationNames.length) {
                opname = this.operationNames[theOperationId];
            }
            if (opname != null) continue;
            this.operationNames = null;
        } while (opname == null && !fetchedOperations);
        if (opname == null || opname.length() < 1) {
            throw new VWException("vw.api.VWQueueConvertIToOOperationIdNotFound", "Operation Id not found.");
        }
        return this.translateStr(opname);
    }

    public String[] fetchOperationNames() throws VWException {
        if (this.queueType == 3) {
            throw new VWException("vw.api.VWQueueNoOperationName", "Operation Names don''t exist on system queues.");
        }
        this.operationNames = this.cmdSession.getQueueOperations(this.getAuthoredName());
        String[] opTransNames = this.translateArr(this.operationNames);
        return opTransNames;
    }

    public boolean getIsConnectorQueue() throws VWException {
        return this.isConnectorQueue;
    }

    protected VWWorkBasket[] fetchSomeWorkBaskets(String[] workBasketNames) throws VWException {
        InternalVWWorkBasket[] _workBaskets = this.cmdSession.fetchWorkBasketsForQueue(this.classId, workBasketNames);
        int nWBs = _workBaskets == null ? 0 : _workBaskets.length;
        VWWorkBasket[] res = new VWWorkBasket[nWBs];
        if (workBasketNames != null && workBasketNames.length > 0 && workBasketNames.length >= nWBs) {
            for (int i = 0; i < nWBs; ++i) {
                String wbName = _workBaskets[i] != null && _workBaskets[i].wbDef != null ? _workBaskets[i].wbDef.getName() : null;
                res[i] = wbName != null && wbName.trim().equals(workBasketNames[i]) ? VWWorkBasket.getVWWorkBasket(_workBaskets[i], this) : null;
            }
        } else {
            for (int i = 0; i < nWBs; ++i) {
                res[i] = _workBaskets[i] != null && _workBaskets[i].wbDef != null ? VWWorkBasket.getVWWorkBasket(_workBaskets[i], this) : null;
            }
        }
        return res;
    }

    public VWWorkBasket fetchWorkBasket(String workBasketName) throws VWException {
        VWWorkBasket[] res = this.fetchSomeWorkBaskets(new String[]{workBasketName});
        if (res != null && res[0] != null) {
            return res[0];
        }
        throw new VWObjectNotFoundException(VSTR_NOWB.toString(workBasketName), -1L, 2);
    }

    public VWWorkBasket[] fetchWorkBaskets() throws VWException {
        return this.fetchSomeWorkBaskets(null);
    }

    protected void logMessage(int loggingOption, String message) throws VWException {
        if (!VWLoggingOptionType.isUserLoggingOption(loggingOption)) {
            throw new VWException("vw.api.SEInvalidLoggingOptionType", "The logging option is not a valid logging option type.");
        }
        this.cmdSession.logMessage(this.viewId, loggingOption, message);
    }
}

